/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.servlet.logd.LogBlockData;
import com.ibm.hwmca.fw.servlet.logd.LogServletMsg;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.DateTimePattern;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogDisplayerEvent {
    private static final String TRACE_MASKT = "XLDSEVTT";
    private static final String TRACE_MASKF = "XLDSEVTF";
    private static final String TRACE_MASKD = "XLDSEVTD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final String _eventTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.title").toString();
    private static final String _linkRefresh = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.refresh.name").toString();
    private static final String _linkPurge = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.purge.name").toString();
    private static final String _linkHelp = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.help.name").toString();
    private static final String _linkReadLog = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.read.log.name").toString();
    private static final String _linkSelectClasses = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.select.classes.name").toString();
    private static final String _linkSelectAll = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.link.select.all.name").toString();
    private static final String _eventidText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.eventid").toString();
    private static final String _dateText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.date").toString();
    private static final String _timeText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.time").toString();
    private static final String _typeText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.type").toString();
    private static final String _nameText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.name").toString();
    private static final String _infoData = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.info").toString();
    private static final String _errorData = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.error").toString();
    private static final String _dataText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.data").toString();
    private static final String _typee = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.typee").toString();
    private static final String _typei = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.eventsummary.typei").toString();
    private static final String BLANKS = "                                                                      ";
    private static final int EVENTID_LENGTH = 8;
    private static final int NAME_LENGTH = 12;
    private static final int DATE_LENGTH = 10;
    private static final int TIME_LENGTH = 12;
    private static final int TYPE_LENGTH = 4;
    private static final int TOTAL_LENGTH = 80;
    private static boolean _refcodeProgramExists;

    protected static Log[] getEventLogs(HttpServletRequest request, HttpServletResponse response, Byte[] logClass, String logName) throws HException {
        Trace.trace(TRACE_MASKF, "-> LogDisplayerEvent.getEventLogs().");
        Trace.trace(TRACE_MASKF, "file name to read is [" + logName + "]");
        Log[] logs = null;
        logs = Log.retrieveSummary(logClass, null, null, null, logName);
        Trace.trace(TRACE_MASKF, "<- LogDisplayerEvent.getEventLogs(). file name to read is [" + logName + "]");
        return logs;
    }

    private static String formatEventLogData(Log logData, StringBuffer strBuffer, DateFormat datePattern, DateFormat timePattern, String logFileName) {
        String logClassStr = HexString.toHex(logData.getLogClass(), true).toUpperCase();
        Trace.trace(TRACE_MASKD, "class = " + logClassStr);
        String logTypeStr = HexString.toHex(logData.getLogType(), true).toUpperCase();
        Trace.trace(TRACE_MASKD, "type = " + logTypeStr);
        Short logUser = new Short(logData.getUser());
        short lUser = logUser;
        short swapUser = (short)((lUser & 0xFF) << 8 | lUser >> 8 & 0xFF);
        String logUserStr = HexString.toHex(swapUser, true).toUpperCase();
        Trace.trace(TRACE_MASKD, "user = " + logUserStr);
        String eventidString = logClassStr + logTypeStr + logUserStr;
        Date timeStamp = logData.getTimestamp();
        String dateString = datePattern.format(timeStamp);
        String timeString = timePattern.format(timeStamp).trim();
        String type = logData.isError() ? _errorData : _infoData;
        Trace.trace(TRACE_MASKD, "IEtype = " + logData.isError());
        String nameString = logData.getEventName();
        Trace.trace(TRACE_MASKD, "name = " + nameString);
        String dataString = logData.getTowerData();
        dataString = LogDisplayerEvent.setUpData(dataString);
        String logBlockLinkStart = "<A href=\"logd?reqtype=logblock&logfname=" + logFileName;
        String logBlockLinkEnd = "\">" + eventidString + "&nbsp;" + dateString + "&nbsp;" + timeString + "</A>" + "&nbsp;";
        String eventData = LogDisplayerEvent.getEventData(logFileName, logClassStr, logTypeStr, logUserStr, new Long(timeStamp.getTime()).toString(), dateString, timeString, type, nameString, dataString);
        strBuffer.append(logBlockLinkStart + eventData + logBlockLinkEnd);
        strBuffer.append(LogDisplayerEvent.padBlank(type, 4) + "&nbsp;");
        if (logData.isError()) {
            strBuffer.append("<FONT COLOR=\"FF0000\">");
        }
        strBuffer.append(LogDisplayerEvent.padBlank(nameString, 12) + "&nbsp;");
        if (logData.isError()) {
            strBuffer.append("</FONT>");
        }
        if (dataString != null && dataString.length() != 0 && !_refcodeProgramExists) {
            strBuffer.append(dataString + "<br>");
        } else if (dataString != null && dataString.length() != 0) {
            String dataLink = "<A href=\"logd?reqtype=refcodedesc&logdata=" + dataString + "\">" + dataString + "<br>" + "</A>";
            strBuffer.append(dataLink);
        } else {
            strBuffer.append("<br>");
        }
        return strBuffer.toString();
    }

    protected static StringBuffer formatEventLogData(Log[] logData, String logFileName) {
        int numLogData = logData.length;
        StringBuffer strBuffer = new StringBuffer(80 * (numLogData + 1));
        StringBuffer litStrBuffer = new StringBuffer(80);
        Object timeStamp = null;
        UserContext userContext = UserContext.getCurrentUserContext();
        Locale locale = null;
        locale = userContext == null ? Locale.getDefault() : userContext.getLocale();
        if (locale == null) {
            Trace.trace(TRACE_MASKF, "LOCALE IS NULL");
        }
        DateFormat datePattern = DateTimePattern.getDatePattern(locale);
        DateFormat timePattern = DateTimePattern.getTimeWithMillisecondsPattern(locale);
        strBuffer.append(LogDisplayerEvent.padBlank(_eventidText, 8) + "&nbsp;");
        strBuffer.append(LogDisplayerEvent.padBlank(_dateText, 10) + "&nbsp;");
        strBuffer.append(LogDisplayerEvent.padBlank(_timeText, 12) + "&nbsp;");
        strBuffer.append(LogDisplayerEvent.padBlank(_typeText, 4) + "&nbsp;");
        strBuffer.append(LogDisplayerEvent.padBlank(_nameText, 12) + "&nbsp;");
        strBuffer.append(_dataText + "&nbsp;" + "<br>");
        for (int i = 0; i < numLogData; ++i) {
            strBuffer.append(LogDisplayerEvent.formatEventLogData(logData[i], litStrBuffer, datePattern, timePattern, logFileName));
            litStrBuffer.setLength(0);
        }
        return strBuffer;
    }

    protected static String padBlank(String str, int count) {
        int len = str.length();
        if (len < count) {
            int padCount = count - len;
            str = str + BLANKS.substring(0, padCount);
        }
        return str;
    }

    protected static StringBuffer format1EventLog(LogBlockData logBlockData) {
        StringBuffer str = new StringBuffer(80);
        str.append(LogDisplayerEvent.padBlank(_eventidText, 8) + "&nbsp;" + LogDisplayerEvent.padBlank(_dataText, 10) + "&nbsp;" + LogDisplayerEvent.padBlank(_timeText, 12) + "&nbsp;" + LogDisplayerEvent.padBlank(_typeText, 4) + "&nbsp;" + LogDisplayerEvent.padBlank(_nameText, 12) + "&nbsp;" + _dataText + "&nbsp;" + "<br>");
        str.append(logBlockData.getLogClass() + logBlockData.getLogType() + logBlockData.getLogUser() + "&nbsp;" + logBlockData.getFormattedDate() + "&nbsp;" + logBlockData.getFormattedTime() + "&nbsp;");
        str.append(LogDisplayerEvent.padBlank(logBlockData.getIeType(), 4) + "&nbsp;");
        if (logBlockData.getIeType().equals(_errorData)) {
            str.append("<FONT COLOR=\"FF0000\">");
        }
        str.append(LogDisplayerEvent.padBlank(logBlockData.getName(), 12));
        if (logBlockData.getIeType().equals(_errorData)) {
            str.append("</FONT>");
        }
        if (logBlockData.getData() != null && logBlockData.getData().length() != 0) {
            str.append("&nbsp;" + logBlockData.getData());
        }
        return str;
    }

    protected static void displayEvents(HttpServletRequest request, HttpServletResponse response, String reqType, String logFileName, Byte[] logClasses, short errid) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> LogDisplayerEvent.displayEvents() for reqType=" + reqType);
        Log[] logData = null;
        try {
            logData = LogDisplayerEvent.getEventLogs(request, response, logClasses, logFileName);
        }
        catch (HException hex) {
            Trace.trace(TRACE_MASKF, "Error reading the log file.");
            FrameworkLog log = new FrameworkLog(_logInfo, errid, hex);
            if (logFileName != null && logFileName.length() != 0) {
                log.add("logName=" + logFileName);
            }
            log.add("reqType requesting to read the log summary =" + reqType);
            log.log();
            throw hex;
        }
        if (logData == null || logData.length == 0) {
            if (reqType.equals("selbyclasd")) {
                LogServletMsg.displayMsg(request, response, _eventTitle, "XLDSNCLO", MsgType.INFORMATION_MESSAGE);
            } else {
                LogServletMsg.displayMsg(request, response, _eventTitle, "XLDSNLOG", MsgType.INFORMATION_MESSAGE);
            }
        } else {
            boolean nFile = true;
            String newFile = request.getParameter("nfile");
            if (newFile == null || newFile.length() == 0) {
                nFile = false;
            }
            Trace.trace(TRACE_MASKF, "There are " + logData.length + " log entries returned");
            PrintWriter out = response.getWriter();
            StringBuffer strBuffer = LogDisplayerEvent.formatEventLogData(logData, logFileName);
            out.print("<html> <script src='/js/servlettask/keys.js'></script><head><title>" + _eventTitle + "</title></head>" + "<body onload='window.focus(); hideCancel();' > <pre>");
            String refresh = "<A href=\"logd?reqtype=refresh&logfname=" + logFileName;
            if (nFile) {
                refresh = refresh + "&" + "nfile" + "=" + "y";
            }
            refresh = refresh + "\">" + _linkRefresh + "</A>" + "  ";
            out.print(refresh);
            String selAll = "<A href=\"logd?reqtype=allclass&logfname=" + logFileName;
            if (nFile) {
                selAll = selAll + "&" + "nfile" + "=" + "y";
            }
            selAll = selAll + "\">" + _linkSelectAll + "</A>" + "  ";
            out.print(selAll);
            String selClass = "<A href=\"logd?reqtype=selbyclas&logfname=" + logFileName;
            if (nFile) {
                selClass = selClass + "&" + "nfile" + "=" + "y";
            }
            selClass = selClass + "\">" + _linkSelectClasses + "</A>" + "  ";
            out.print(selClass);
            out.print("<A href=\"logd?reqtype=getfilename\">" + _linkReadLog + "</A>" + "  ");
            out.print("<A href=\"logd?reqtype=help\">" + _linkHelp + "</A>" + "  ");
            if (!nFile) {
                out.print("<A href=\"logd?reqtype=purge\">" + _linkPurge + "</A>");
            }
            out.print("<br>&nbsp;<br>");
            out.print(strBuffer.toString());
            out.print("</pre> </body></html>");
        }
        Trace.trace(TRACE_MASKF, "<- LogDisplayerEvent.displayEvents() for reqType=" + reqType);
    }

    protected static void displayEvents(HttpServletRequest request, HttpServletResponse response, String reqType, Byte[] logClasses, short errid) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> LogDisplayerEvent.displayEvents() for reqType=" + reqType);
        String logFileName = LogDisplayerEvent.getLogFileName(request);
        LogDisplayerEvent.displayEvents(request, response, reqType, logFileName, logClasses, errid);
        Trace.trace(TRACE_MASKF, "<- LogDisplayerEvent.displayEvents() for reqType=" + reqType);
    }

    protected static void displayEvents(HttpServletRequest request, HttpServletResponse response, String id, short errid) throws IOException, HException {
        LogDisplayerEvent.displayEvents(request, response, id, null, errid);
    }

    protected static String getEventData(String logFileName, String logClass, String logType, String logUser, String timeStamp, String formattedDate, String formattedTime, String ieType, String name, String data) {
        String eventData = "&logfname=" + logFileName + "&" + "logclass" + "=" + logClass + "&" + "logtype" + "=" + logType + "&" + "loguser" + "=" + logUser + "&" + "timestamp" + "=" + timeStamp + "&" + "formatteddate" + "=" + formattedDate + "&" + "formattedtime" + "=" + formattedTime + "&" + "ietype" + "=" + ieType + "&" + "name" + "=" + name;
        if (data != null && data.length() != 0) {
            eventData = eventData + "&" + "logdata" + "=" + data;
        }
        return eventData;
    }

    protected static String getEventData(LogBlockData logBlockData) {
        String eventData = LogDisplayerEvent.getEventData(logBlockData.getLogFileName(), logBlockData.getLogClass(), logBlockData.getLogType(), logBlockData.getLogUser(), logBlockData.getTimeStamp(), logBlockData.getFormattedDate(), logBlockData.getFormattedTime(), logBlockData.getIeType(), logBlockData.getName(), logBlockData.getData());
        return eventData;
    }

    protected static String getLogFileName(HttpServletRequest request) {
        String logFileName = request.getParameter("logfname");
        if (logFileName == null || logFileName.length() == 0) {
            logFileName = "log";
            Trace.trace(TRACE_MASKF, "Using default log file name");
        }
        Trace.trace(TRACE_MASKF, "Using logfileName=" + logFileName);
        return logFileName;
    }

    protected static boolean newFile(HttpServletRequest request) {
        boolean nFile = true;
        String newFile = request.getParameter("nfile");
        if (newFile == null) {
            nFile = false;
        }
        return nFile;
    }

    private static String setUpData(String data) {
        if (data != null && data.length() > 60) {
            data = data.substring(0, 60) + "...";
        }
        return data;
    }

    static {
        try {
            Process pid = Runtime.getRuntime().exec("bbresrc");
            _refcodeProgramExists = true;
        }
        catch (IOException e) {
            _refcodeProgramExists = false;
            Trace.trace(TRACE_MASKF, "Default to No refcode description program.");
        }
    }
}

